def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'item1', 'item2', 'item3', and 'bin'
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        bin_pos = positions['bin']

        # === Task Plan Execution ===
        # Step 1: Move to item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')  # Assuming the robot is already in the correct room
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')  # Move to the room where the bin is located
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 4: Place item1 in the bin
        print("[Task] Placing item1 in the bin...")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing item1 in the bin!")
            return

        # Step 5: Repeat for item2
        print("[Task] Moving to item2 at:", item2_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        print("[Task] Picking item2...")
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        print("[Task] Placing item2 in the bin...")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing item2 in the bin!")
            return

        # Step 6: Repeat for item3
        print("[Task] Moving to item3 at:", item3_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')
        if done:
            print("[Task] Task ended after moving to item3!")
            return

        print("[Task] Picking item3...")
        obs, reward, done = pick(env, task, target_pos=item3_pos)
        if done:
            print("[Task] Task ended after picking item3!")
            return

        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        print("[Task] Placing item3 in the bin...")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing item3 in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()