def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object and a bin object
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # Step 1: Approach and pick up the rubbish
        print("[Task] Approaching and picking up the rubbish at:", rubbish_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=rubbish_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # Step 2: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        # Assuming we have a move function to navigate to the bin
        # Here we would need to implement a move function if not provided
        # For now, we will assume a direct call to move
        # move(env, task, current_location, bin_pos)  # Uncomment and implement as needed

        # Step 3: Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos
        )
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()