def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['ball1']  # Replace with actual object names
        object_2_pos = positions['ball2']  # Replace with actual object names
        robot_initial_pos = positions['rooma']  # Assuming the robot starts in rooma

        # Move to the initial position (if needed)
        print("[Task] Moving to initial position:", robot_initial_pos)
        obs, reward, done = move(env, robot_initial_pos, robot_initial_pos)

        # Pick up the first object
        print("[Task] Picking up object_1 at:", object_1_pos)
        obs, reward, done = pick(env, task, target_pos=object_1_pos)

        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Place the first object in a designated location (e.g., roomb)
        print("[Task] Placing object_1 in roomb")
        obs, reward, done = place(env, task, target_pos='roomb')

        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Pick up the second object
        print("[Task] Picking up object_2 at:", object_2_pos)
        obs, reward, done = pick(env, task, target_pos=object_2_pos)

        if done:
            print("[Task] Task ended after picking object_2!")
            return

        # Place the second object in a designated location (e.g., roomc)
        print("[Task] Placing object_2 in roomc")
        obs, reward, done = place(env, task, target_pos='roomc')

        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()