def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        rubbish_pos = positions['rubbish']  # Assuming 'rubbish' is now included in the object list

        # === Task Plan Execution ===
        print("[Task] Manipulating rubbish at:", rubbish_pos)
        
        # Step 1: Pick up the rubbish
        obs, reward, done = pick(
            env,
            task,
            target_pos=rubbish_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 2: Place the rubbish in a designated location (e.g., a bin)
        bin_pos = positions['bin']  # Assuming 'bin' is a designated location for disposal
        print("[Task] Placing rubbish at:", bin_pos)
        
        obs, reward, done = place(
            env,
            task,
            target_pos=bin_pos
        )
        
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()