def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the object we want to manipulate is called 'rubbish'
        rubbish_pos = positions['rubbish']  # Ensure 'rubbish' is in the object list

        # Move to the location of the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Pick up the rubbish
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Move to the disposal location (e.g., 'roomb')
        print("[Task] Moving to disposal location...")
        obs, reward, done = move(env, 'rooma', 'roomb')  # Adjust room names as necessary
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # Place the rubbish in the disposal location
        print("[Task] Placing rubbish...")
        obs, reward, done = place(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()