def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a single object to manipulate
        object_pos = positions['object_1']  # Replace 'object_1' with the actual object key

        # 1) Approach and manipulate the object
        print("[Task] Manipulating object at:", object_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # 2) Place the object in a designated location (e.g., trash bin)
        trash_bin_pos = positions['trash_bin']  # Replace 'trash_bin' with the actual bin key
        print("[Task] Placing object in trash bin at:", trash_bin_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=trash_bin_pos
        )
        
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()