def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the object we need to manipulate is 'rubbish'
        rubbish_pos = positions['rubbish']  # Update this based on your actual object names

        # 1) Move to the rubbish location
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # 2) Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # 3) Move to the disposal location (assuming a predefined disposal location)
        disposal_pos = positions['disposal']  # Update this based on your actual disposal location
        print("[Task] Moving to disposal location at:", disposal_pos)
        obs, reward, done = move(env, task, from_room=rubbish_pos, to_room=disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # 4) Place the rubbish in the disposal location
        print("[Task] Placing rubbish in disposal.")
        obs, reward, done = place(env, task, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()