def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects: 'rubbish' and 'ball'
        rubbish_pos = positions['rubbish']
        ball_pos = positions['ball']

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, 'rooma', 'roomb')  # Example rooms
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, 'rubbish', 'roomb')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the disposal area
        print("[Task] Moving to disposal area.")
        obs, reward, done = move(env, task, 'roomb', 'roomc')  # Example disposal area
        if done:
            print("[Task] Task ended after moving to disposal area!")
            return

        # Step 4: Place the rubbish in the disposal area
        print("[Task] Placing rubbish in disposal area.")
        obs, reward, done = place(env, task, target_pos=(1, 1, 0))  # Example target position
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()