import numpy as np

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(task.get_observation())

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        bin_pos = positions['bin']

        # === Task Plan Execution ===
        # Step 1: Pick item1 from the table
        print("[Task] Picking item1 from the table.")
        obs, reward, done = task.pick(
            target_pos=item1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 2: Place item1 into the bin
        print("[Task] Placing item1 into the bin.")
        obs, reward, done = task.place(
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

        # Step 3: Pick item2 from the table
        print("[Task] Picking item2 from the table.")
        obs, reward, done = task.pick(
            target_pos=item2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 4: Place item2 into the bin
        print("[Task] Placing item2 into the bin.")
        obs, reward, done = task.place(
            target_pos=bin_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()