def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'item1', 'item2', 'item3' and are in the positions dictionary
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        robot_start_pos = positions['robot_start']

        # Move to the position of item1
        print("[Task] Moving to item1 position:", item1_pos)
        obs, reward, done = move(env, robot_start_pos, item1_pos)
        if done:
            print("[Task] Task ended while moving to item1!")
            return

        # Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, item1_pos)
        if done:
            print("[Task] Task ended while picking item1!")
            return

        # Move to the position of item2
        print("[Task] Moving to item2 position:", item2_pos)
        obs, reward, done = move(env, item1_pos, item2_pos)
        if done:
            print("[Task] Task ended while moving to item2!")
            return

        # Place item1 at item2's position
        print("[Task] Placing item1 at item2's position...")
        obs, reward, done = place(env, task, item2_pos)
        if done:
            print("[Task] Task ended while placing item1!")
            return

        # Move to the position of item3
        print("[Task] Moving to item3 position:", item3_pos)
        obs, reward, done = move(env, item2_pos, item3_pos)
        if done:
            print("[Task] Task ended while moving to item3!")
            return

        # Pick item3
        print("[Task] Picking item3...")
        obs, reward, done = pick(env, task, item3_pos)
        if done:
            print("[Task] Task ended while picking item3!")
            return

        # Place item3 at a designated location (e.g., a drop-off point)
        drop_off_pos = positions['drop_off']
        print("[Task] Placing item3 at drop-off position:", drop_off_pos)
        obs, reward, done = place(env, task, drop_off_pos)
        if done:
            print("[Task] Task ended while placing item3!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()