def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'tomato1' is the object we need to manipulate
        if 'tomato1' not in positions:
            print("Error: 'tomato1' not found in the object positions.")
            return

        tomato1_pos = positions['tomato1']
        trash_can_pos = positions['trash_can']  # Assuming trash can is also in the positions

        # 1) Move to the location of the object (tomato1)
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, 'current_room', 'room_with_tomato1')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to tomato1!")
            return

        # 2) Pick up the tomato1
        print("[Task] Picking up tomato1...")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended while picking up tomato1!")
            return

        # 3) Move to the trash can
        print("[Task] Moving to trash can at:", trash_can_pos)
        obs, reward, done = move(env, 'room_with_tomato1', 'room_with_trash_can')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to trash can!")
            return

        # 4) Place the tomato1 in the trash can
        print("[Task] Placing tomato1 in the trash can...")
        obs, reward, done = place(env, task, target_pos=trash_can_pos)
        if done:
            print("[Task] Task ended while placing tomato1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()