def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a trash object to pick and a disposal location
        trash_pos = positions['trash']  # Replace 'trash' with the actual object name
        disposal_pos = positions['disposal']  # Replace 'disposal' with the actual location name

        # Check if the trash object is available
        if trash_pos not in env.object_list:
            raise ValueError("Target object (trash) not in object list")

        # Step 1: Move to the trash location
        print("[Task] Moving to trash location:", trash_pos)
        obs, reward, done = move(env, 'current_room', 'trash_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to trash!")
            return

        # Step 2: Pick the trash
        print("[Task] Picking up the trash at:", trash_pos)
        obs, reward, done = pick(env, task, target_pos=trash_pos)
        if done:
            print("[Task] Task ended after picking trash!")
            return

        # Step 3: Move to the disposal location
        print("[Task] Moving to disposal location:", disposal_pos)
        obs, reward, done = move(env, 'trash_room', 'disposal_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to disposal!")
            return

        # Step 4: Place the trash in the disposal location
        print("[Task] Placing the trash at disposal location:", disposal_pos)
        obs, reward, done = place(env, task, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after placing trash!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()