from code_gen.llm import llm_response

def verify_code_with_spec(task_name, idx, domain_pddl, observation, instruction, spec, generated_code):
    prompt = f"""
Task: {task_name}  
Specification: {spec}  
Generated Code: {generated_code}

Perform a static analysis to verify if the Generated Code meets the Specification.  
Use the Specification as the primary source of truth, but **do not reject or simplify the code if it contains additional parameters, conditions, or information—unless those additions contradict the Specification.**  

If a functionality, parameter, or behavior in the Generated Code is **also found in the Specification**, consider it verified.  
Do **not** reduce or remove details from the code unless the Specification explicitly requires a different behavior.

- Do not use any external common sense or background knowledge.  
- Minor differences in naming or style (e.g., variable names) are acceptable as long as the behavior aligns.  

If the Generated Code correctly implements the intended behavior described in the Specification, return `none`.  
If there are significant deviations that affect correctness, return **only** the feedback on what needs to be corrected, without any additional explanation."""

    response = llm_response("openai", prompt, check_time=True)

    line_width = 60
    step_title = f"Verification {idx}"
    PURPLE = "\033[95m"
    GREEN = "\033[92m"
    RED = "\033[91m"
    RESET = "\033[0m"

    print(PURPLE + "=" * line_width + RESET)
    print(step_title.center(line_width))

    def colored_center(text, color):
        centered = text.center(line_width)
        return centered.replace(text, color + text + RESET)

    if "none" in response.lower():
        print(colored_center("Result: PASS", GREEN))
        print(PURPLE + "=" * line_width + RESET)
        return True, "none"
    else:
        cleaned_response = response.strip()
        print(colored_center("Result: FAIL", RED))
        print(PURPLE + "=" * line_width + RESET)
        return False, cleaned_response