import pandas as pd, matplotlib.pyplot as plt, math

df = pd.read_csv("Input_Your_Path/temp.csv") 

plt.rcParams.update({
    "font.family": "serif",
    "font.size": 8,
    "axes.labelsize": 8,
    "axes.titlesize": 8,
    "legend.fontsize": 7,
    "xtick.labelsize": 7,
    "ytick.labelsize": 7,
    "axes.linewidth": .6,
    "lines.linewidth": 1.0,
})

steps, before_conf, after_conf = [], [], []
max_iter = df["iteration"].max()
for i in range(max_iter + 1):
    tgt = df.loc[df["iteration"] == i, "target_skill"].iloc[0]
    before_val = df[(df["iteration"] == i) & (df["skill_name"] == tgt)]["skill_confidence"].iloc[0]
    steps.append(i); before_conf.append(before_val)

    nxt = df[(df["iteration"] == i+1) & (df["skill_name"] == tgt)]
    after_conf.append(nxt["skill_confidence"].iloc[0] if not nxt.empty else math.nan)

total_conf = (
    df[["iteration", "total_confidence"]]
      .drop_duplicates()
      .set_index("iteration")
      .reindex(range(max_iter + 1))
      ["total_confidence"]
      .tolist()
)

# -------------------- Plot ------------------------------
fig_w, fig_h = 3.3, 2.2  # inch (single‑column size)
plt.figure(figsize=(fig_w, fig_h))

bar_w = .30
x_bef = [s - bar_w/2 for s in steps]
x_aft = [s + bar_w/2 for s in steps]
plt.bar(x_bef, before_conf, bar_w, color='yellow', alpha=.9,
        edgecolor='black', linewidth=.4, label='Target skill (before)')
x_aft_f = [x for x, y in zip(x_aft, after_conf) if not math.isnan(y)]
aft_conf_f = [y for y in after_conf if not math.isnan(y)]
plt.bar(x_aft_f, aft_conf_f, bar_w, color='yellow', alpha=.4,
        edgecolor='black', linewidth=.4, label='Target skill (after)')

plt.plot(steps, total_conf, marker='s', color='blue',
         markersize=3, markeredgewidth=.5, label='Total confidence')

plt.xticks(steps)
plt.xlabel("Exploration step")
plt.ylabel("Confidence (%)")
plt.title("Confidence progression per exploration")
plt.grid(axis='y', linestyle=':', linewidth=.4)
plt.ylim(0, 100)
plt.legend(frameon=False)
plt.tight_layout()

plt.savefig("Input_Your_Path/ablation.pdf")
plt.show()