import pandas as pd
import numpy as np

csv_paths = [
    "Input_Your_Path/__exploration_long_horizon_1_type3/code/conf_log_high_seed1.csv",   # task A
    "Input_Your_Path/__exploration_long_horizon_1_type3/code/conf_log_high_seed2.csv",   # task B
]

dfs = []
for path in csv_paths:
    df = pd.read_csv(path)
    df_unique = df[["iteration", "total_confidence"]].drop_duplicates()
    dfs.append(df_unique)

df_all = pd.concat(dfs, ignore_index=True)

summary = (
    df_all.groupby("iteration")["total_confidence"]
          .agg(Confidence_mean="mean",
               Confidence_std=lambda x: np.std(x, ddof=1))
          .reset_index()
)

print(summary)