from .llm import llm_response
from .prompt.code_gen import code_gen_prompt, realworld_code_gen_prompt

import re

def code_gen_with_skill_save(
    task_name, domain_pddl, observation, instruction, spec, skill_code_text,
    available_skills, object_list, feedback, prev_code, exploration_knowledge,
    obs_type=None, seed=None,
    validated_until_skill_index=0
):


    skill_call_pattern = r'obs\s*,\s*reward\s*,\s*done\s*=\s*(\w+)\(([^)]*)\)'
    matches = re.findall(skill_call_pattern, prev_code)

   
    skill_calls = []
    for match in matches:
        skill_name = match[0]
        args_str = match[1]
        skill_calls.append({
            "skill_name": skill_name,
            "args_str": args_str
        })


    frozen_calls = skill_calls[:validated_until_skill_index]  
    frozen_code_lines = []
    for sc in frozen_calls:
        line = f"obs, reward, done = {sc['skill_name']}({sc['args_str']})"
        frozen_code_lines.append(line)


    frozen_code_part = "\n".join(frozen_code_lines)


    goal = instruction
    prompt = code_gen_prompt(
        domain_pddl=domain_pddl,
        observation=observation,
        goal=goal,
        spec=spec,
        skill_code=skill_code_text,
        available_skills=available_skills,
        object_list_position=object_list,
        feedback=feedback,
        prev_code=prev_code,
        exploration_knowledge=exploration_knowledge,
        frozen_code_part=frozen_code_part
    )


    response = llm_response("openai", prompt, check_time=True)
    line_width = 60
    msg = "Code generation completed successfully."


    GRAY = "\033[90m"
    LIGHT_GREEN = "\033[92m"
    RESET = "\033[0m"

    print(GRAY + "=" * line_width + RESET)
    print(LIGHT_GREEN + msg.center(line_width) + RESET)
    print(GRAY + "=" * line_width + RESET)


    return response

def realworld_code_gen_with_skill_save(
    task_name,
    domain_pddl,
    observation,
    instruction,                 # == goal
    spec,
    skill_code_text,
    available_skills,
    object_list,
    feedback,
    prev_code,
    exploration_knowledge,
    obs_type=None,
    seed=None,
    plan_content = None,
    validated_until_skill_index=0
):



    skill_call_pattern = r'robot\.\s*(\w+)\s*\(([^)]*)\)'
    matches = re.findall(skill_call_pattern, prev_code)


    skill_calls = [
        {"skill_name": fn, "args_str": args}
        for fn, args in matches
    ]

    frozen_calls = skill_calls[:validated_until_skill_index]
    frozen_code_lines = [
        f"robot.{sc['skill_name']}({sc['args_str']})"
        for sc in frozen_calls
    ]
    frozen_code_part = "\n".join(frozen_code_lines)


    goal = instruction
    prompt = realworld_code_gen_prompt(
        domain_pddl=domain_pddl,
        observation=observation,
        goal=goal,
        spec=spec,
        skill_code=skill_code_text,
        available_skills=available_skills,
        object_list_position=object_list,
        feedback=feedback,
        prev_code=prev_code,
        exploration_knowledge=exploration_knowledge,
        frozen_code_part=frozen_code_part,    
        plan_content=plan_content,
    )


    response = llm_response("openai", prompt, check_time=True)


    line_width = 60
    GRAY, LIGHT_GREEN, RESET = "\033[90m", "\033[92m", "\033[0m"
    print(GRAY + "=" * line_width + RESET)
    print(LIGHT_GREEN + "Real‑world code generation completed successfully.".center(line_width) + RESET)
    print(GRAY + "=" * line_width + RESET)

    return response