import time
import google.generativeai as genai

GOOGLE_API_KEY = "Input_Your_API_KEY"
genai.configure(api_key=GOOGLE_API_KEY)
model = genai.GenerativeModel('gemini-1.5-flash')

def gemini_response(prompt, temperature=0.0, stop_sequences=[''], check_time=True):
    import grpc
    start_time = time.time()
    user_prompt = prompt

    response = model.generate_content(
        user_prompt,
        generation_config=genai.types.GenerationConfig(
            temperature=temperature
        )
    )

    end_time = time.time()
    execution_time = end_time - start_time
    if check_time:
        print(f"{'='*40}")
        print(f"{'Execution Time:':<20} {execution_time:>10.2f} sec")
        print(f"{'='*40}")
        print()
    return response.text