def translate_prompt(domain_pddl_content: str, python_code: str) -> str:
    prompt_template = f"""
PDDL Conversion Prompt

Input:
1. Existing Domain PDDL File:
   {domain_pddl_content}
2. Python Code:
   {python_code}

Task:
- Convert the Python functions into corresponding PDDL actions and update the `domain.pddl`.
- For each function:
  1. Convert the `if` statements (conditions) into `:precondition` blocks using only predicates from the original `:predicates` section.
  2. Convert the `return` values (effects) into `:effect` blocks using only predicates from the original `:predicates` section.
  3. Ensure the variable types match the PDDL types in the existing domain.
- Important Constraint:
  - **Do not create new predicates.** Only use predicates that exist in the provided `:predicates` section.
  - Add new actions only if they do not already exist in the domain.
  - Do not use code blocks for the output format; use plain text format instead.

Example:
Given Python code:
```python
def move(from_room, to_room, obs):
    if (f"room({{from_room}})" in obs.literals and
        f"room({{to_room}})" in obs.literals and
        f"at-robby({{from_room}})" in obs.literals):
        return f"move({{from_room}}:default,{{to_room}}:default)"
    else:
        return False
```
The corresponding PDDL action should be:
```lisp
(:action move
  :parameters (?from_room - room ?to_room - room)
  :precondition (and (room ?from_room) (room ?to_room) (at-robby ?from_room))
  :effect (and (not (at-robby ?from_room)) (at-robby ?to_room))
)
```

Notes:
- If a predicate referenced in the Python code is missing in the provided PDDL, skip it and do not include it in the `:precondition` or `:effect`.
- The output must be a valid `domain.pddl` file that includes only actions generated from the Python functions using the provided predicates.
"""
    return prompt_template