import os
import argparse
import subprocess

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--env", nargs="+", required=True)
    parser.add_argument("--type", type=int, choices=[1, 2, 3, 4], required=True)
    args = parser.parse_args()

    rlbench_tasks = ["open_drawer"]
    observation_types = ["high", "middle", "low", "oracle"]
    seed_count = 2
    instruction_count = 5

    for env_name in args.env:
        if env_name != "rlbench":
            continue

        for task in rlbench_tasks:
            task_name_with_type = f"{task}_type{args.type}"
            base_dir = os.path.join("Input_Your_Path", env_name, task_name_with_type)
            code_dir = os.path.join(base_dir, "code")
            result_path = os.path.join(base_dir, "result.txt")
            result_all_path = os.path.join(base_dir, "result_all.txt")

            if not os.path.exists(code_dir):
                print(f"[WARNING] Code directory not found: {code_dir}")
                continue

            with open(result_path, "w") as result_file:
                for obs_type in observation_types:
                    for seed in range(1, seed_count + 1):
                        for idx in range(1, instruction_count + 1):
                            exe_script_path = os.path.join(code_dir, f"exe_code_{obs_type}_seed{seed}_{idx}.py")

                            if not os.path.isfile(exe_script_path):
                                print(f"[INFO] Script not found: {exe_script_path}. Skipping.")
                                result_file.write(f"{obs_type}_seed{seed}_init_{idx} -> NotFound\n")
                                continue

                            try:
                                completed = subprocess.run(
                                    ["python3", exe_script_path],
                                    capture_output=True,
                                    text=True
                                )
                                output = completed.stdout

                                with open(result_all_path, "a") as all_out_file:
                                    all_out_file.write(f"\n===== {env_name}/{task_name_with_type}/{obs_type}_seed{seed}_init_{idx} START =====\n")
                                    all_out_file.write(output)
                                    all_out_file.write(f"\n===== {env_name}/{task_name_with_type}/{obs_type}_seed{seed}_init_{idx} END =====\n")

                                score = 100 if "Task completed successfully! Reward: 1.0" in output else 0
                                result_file.write(f"{obs_type}_seed{seed}_init_{idx} -> {score}\n")
                                print(f"[{env_name}][{task_name_with_type}] {obs_type}_seed{seed}_init_{idx} -> {score}")

                            except Exception as e:
                                print(f"[ERROR] Failed to run {exe_script_path} with exception: {e}")
                                result_file.write(f"{obs_type}_seed{seed}_init_{idx} -> Error\n")
                                with open(result_all_path, "a") as all_out_file:
                                    all_out_file.write(f"\n===== {env_name}/{task_name_with_type}/{obs_type}_seed{seed}_init_{idx} ERROR =====\n")
                                    all_out_file.write(str(e) + "\n")
                                    all_out_file.write("============================================\n")

if __name__ == "__main__":
    main()