from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    try:
        # Step 1: Move from ready-pose to drawer-area
        robot.execute_movement(mode=7)  # execute_go

        # Step 2: Pick the bottom handle at drawer-area (axis=0, approach along x for handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: Pull the bottom drawer with the handle (mode=4, axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: Pick up dice1 (at drawer-area), approach along z-axis
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=1, axis=2)

        # Step 5: Place dice1 into the bottom drawer at left place (axis=2)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

        # Step 6: Move back to ready-pose
        robot.execute_movement(mode=8)  # go_to_ready_pose

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()