from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: execute_pick (pick dice1 from floor)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose (need-ready handling)

        # Step 2: execute_go (move from ready-pose to drawer-area)
        robot.execute_movement((0, 0, 0, 0, 0, 0), mode=7)  # Simulate execute_go

        # Step 3: execute_pick (pick handle_bottom in drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 4: execute_pull (pull drawer_bottom via handle_bottom at drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)

        # Step 5: execute_place (place dice1 into drawer_bottom at drawer-area)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # Go to ready pose (need-ready handling)

        # Step 6: execute_push (push drawer_bottom closed at drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, distance=0.1)

        # Step 7: execute_go (move from drawer-area to ready-pose)
        robot.execute_movement((0, 0, 0, 0, 0, 0), mode=7)  # Simulate execute_go

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
