from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    try:
        # STEP 1: Pick up dice1 from the floor
        #   - Use execute_pick skill
        #   - axis=2 => approach from above (good for general objects like dice)
        #   - Object["dice1"] is not in the provided Object_list["..."] mapping, so handle gracefully
        dice_obj_key = None
        for key in Object:
            # Try to find a dice in Object_list
            if "dice" in key:
                dice_obj_key = key
                break
        if dice_obj_key is None:
            # If not found, raise an exception to alert
            raise ValueError("No dice object found in Object_list for picking.")
        
        robot.execute_movement(Object[dice_obj_key], mode=1, axis=2)   # execute_pick, approach z-axis

        # STEP 2: Place dice into a drawer
        #   - Per goal: "Drop one dice into any open drawer."
        #   - In Object_list, possible place poses:
        #         "drawer_top_place_left", "drawer_top_place_right", 
        #         "drawer_middle_place", 
        #         "drawer_bottom_place_left", "drawer_bottom_place_right"
        #   - Let's pick the first available, e.g. "drawer_top_place_left"

        place_pose_key = None
        for name in ["drawer_top_place_left", "drawer_middle_place", "drawer_bottom_place_left"]:
            if name in Object:
                place_pose_key = name
                break
        if place_pose_key is None:
            # Fallback: check any drawer place position
            for key in Object:
                if "place" in key:
                    place_pose_key = key
                    break
        if place_pose_key is None:
            raise ValueError("No suitable drawer place pose found in Object_list for placing.")

        # Optionally, return to ready pose before placing, if required by skills (per PDDL need-ready).
        try:
            robot.execute_movement(mode=8)  # go_to_ready_pose
        except Exception:
            pass

        robot.execute_movement(Object[place_pose_key], mode=2, axis=2)  # execute_place, approach z-axis

        # Optionally, return to ready pose after completion (for robustness)
        try:
            robot.execute_movement(mode=8)
        except Exception:
            pass

    except Exception as e:
        print(f"Error in Long_horizon_task2_oracle_seq: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
