from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor
        robot.execute_movement(Object["floor"], mode=7)  # execute_go: from ready-pose to floor

        # Step 2: Pick dice1 from floor (axis=2: approach along z)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 3: (No actual movement, but placeholder for possible go from floor to floor)
        robot.execute_movement(Object["floor"], mode=7)  # execute_go: floor to floor (no-op)

        # Step 4: Pick handle_bottom from floor (axis=0: approach along x)
        robot.execute_movement(Object["handle_bottom"], mode=1, axis=0)  # execute_pick

        # Step 5: Pull drawer_bottom with handle_bottom (from floor)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)  # execute_pull

        # Step 6: Place dice1 in drawer_bottom (axis=2: approach along z)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)  # execute_place

        # Step 7: Push drawer_bottom closed (from floor)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, distance=0.1)  # execute_push

        # Step 8: Move from floor to ready-pose
        robot.execute_movement(Object["ready-pose"], mode=7)  # execute_go

    except Exception as e:
        print(f"Exception during oracle execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
