from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # STEP 1: Pick up dice1 from the floor (axis=2 for objects)
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=1, axis=2)  # dice1 is at bottom left place
    except Exception as e:
        print(f"Error during execute_pick dice1: {e}")

    # STEP 2: Move from ready-pose to drawer-area (mode=7 is execute_go)
    try:
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error during execute_go to drawer-area: {e}")

    # STEP 3: Pick up the bottom handle (axis=0 for handles)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick handle_bottom: {e}")

    # STEP 4: Pull the drawer open (execute_pull; mode=4)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.1)  # Open drawer_bottom with handle_bottom
    except Exception as e:
        print(f"Error during execute_pull drawer_bottom: {e}")

    # STEP 5: Place dice1 into drawer_bottom (axis=2 for placing an object)
    try:
        robot.execute_movement(Object["drawer_bottom_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place dice1: {e}")

    # STEP 6: Push drawer bottom closed (execute_push; mode=3)
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, distance=0.1)
    except Exception as e:
        print(f"Error during execute_push drawer_bottom: {e}")

    # STEP 7: Move back to ready-pose (mode=7 is execute_go)
    try:
        robot.execute_movement(mode=7)
    except Exception as e:
        print(f"Error during execute_go to ready-pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
