from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Put a single dice into the drawer.
    Executes actions in strict order as given in the oracle plan/specification.
    Uses only provided skills and object names.
    """

    robot = RobotController()

    try:
        # Step 1: execute_pick dice1 from floor (grasp dice1, axis=2 for dice/object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        robot.execute_movement(mode=8)  # go to ready pose after pick

        # Step 2: execute_pick handle_bottom from floor (grasp handle, axis=0 for handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 3: execute_pull drawer_bottom using handle_bottom at drawer-area
        # (We interpret the location by context; mode=4 is pull, axis=0 for handle, distance=0.1 for safe pull)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: execute_place dice1 into drawer_bottom at drawer-area (axis=2 for object/place action)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)  # go to ready pose after place

        # Step 5: execute_push drawer_bottom at drawer-area (close drawer; axis and distance default)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.08)

    except Exception as e:
        print(f"Error during execution: {str(e)}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()