from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle sequence for "Insert one die into a drawer."
    Using only the provided skills and plan specification.
    """
    robot = RobotController()

    try:
        # Step 1: Pick dice1 from floor (axis=2: approach from above)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 2: Pick handle_bottom from floor (axis=0: approach along x for handle)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
        # Step 3: Pull open drawer_bottom using handle_bottom (at drawer-area)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)
        # Step 4: Place dice1 in drawer_bottom, at drawer-area (axis=2: place from above)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
        # Step 5: Push drawer_bottom closed (at drawer-area)
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Exception during oracle sequence execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()