from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Move from ready-pose to floor
    try:
        robot.execute_movement(Object.get("ready-pose", None), Object.get("floor", None), mode=7)  # execute_go
    except Exception as e:
        print(f"Error in step 1 (execute_go ready-pose -> floor): {e}")

    # Step 2: Pick handle_bottom from floor (for drawer)
    try:
        # axis=0: approach drawer handle along x-axis
        robot.execute_movement(Object.get("handle_bottom", None), mode=1, axis=0)  # execute_pick
    except Exception as e:
        print(f"Error in step 2 (execute_pick handle_bottom): {e}")

    # Step 3: Pull the drawer_bottom open using handle_bottom
    try:
        robot.execute_movement(Object.get("drawer_bottom", None), mode=4, axis=0, distance=0.1)  # execute_pull
    except Exception as e:
        print(f"Error in step 3 (execute_pull drawer_bottom): {e}")

    # Step 4: Move (floor to floor - redundant but included for plan fidelity)
    try:
        robot.execute_movement(Object.get("floor", None), Object.get("floor", None), mode=7)
    except Exception as e:
        print(f"Error in step 4 (execute_go floor -> floor): {e}")

    # Step 5: Pick dice1 from floor (the dice to go in the drawer)
    try:
        # axis=2: approach dice along z-axis
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)  # execute_pick
    except Exception as e:
        print(f"Error in step 5 (execute_pick dice1): {e}")

    # Step 6: Place dice1 in drawer_bottom
    try:
        # Place dice1 in the drawer - approach along z-axis
        # destination: "drawer_bottom_place_left" or similar; but plan says use "drawer_bottom"
        robot.execute_movement(Object.get("dice1", None), Object.get("drawer_bottom", None), mode=2, axis=2)  # execute_place
    except Exception as e:
        print(f"Error in step 6 (execute_place dice1 in drawer_bottom): {e}")

    # Step 7: Move (floor to floor - again, redundant but for plan fidelity)
    try:
        robot.execute_movement(Object.get("floor", None), Object.get("floor", None), mode=7)
    except Exception as e:
        print(f"Error in step 7 (execute_go floor -> floor): {e}")

    # Step 8: Push the drawer_bottom closed
    try:
        # execute_push on drawer_bottom
        robot.execute_movement(Object.get("drawer_bottom", None), mode=3, axis=0, distance=0.1)  # execute_push
    except Exception as e:
        print(f"Error in step 8 (execute_push drawer_bottom): {e}")

    # Step 9: Move back from floor to ready-pose
    try:
        robot.execute_movement(Object.get("floor", None), Object.get("ready-pose", None), mode=7)
    except Exception as e:
        print(f"Error in step 9 (execute_go floor -> ready-pose): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
