from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the drawer handle (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in picking drawer_top_handle: {e}")

    try:
        # Step 2: Pull the top drawer open using the handle (approach along x-axis, distance=0.1)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in pulling drawer_top_handle: {e}")

    try:
        # Step 3: Pick up dice1 from the floor (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in picking dice1: {e}")

    try:
        # Step 4: Go to ready-pose (reset pose)
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in going to ready-pose: {e}")

    try:
        # Step 5: Place dice1 into the top drawer (approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in placing dice1: {e}")

    try:
        # Step 6: Go to ready-pose again (reset pose)
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in going to ready-pose after placing: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()