from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick the top drawer handle (approach along x-axis: axis=0)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick drawer_top_handle: {e}")

    # Step 2: Pull open the top drawer using the handle (approach along x-axis: axis=0, distance=0.1)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull drawer_top_handle: {e}")

    # Step 3: Pick up dice1 (approach along z-axis: axis=2)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in execute_pick dice1: {e}")

    # Step 4: Go to ready pose (required by need-ready flag)
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in go_to_ready_pose after pick dice1: {e}")

    # Step 5: Place dice1 into the top drawer (approach along z-axis: axis=2)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in execute_place dice1: {e}")

    # Step 6: Go to ready pose (required by need-ready flag)
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in go_to_ready_pose after place dice1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()