from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick up the top drawer handle (execute_pick_handle), approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 1 (execute_pick_handle drawer_top_handle): {e}")

    try:
        # Step 2: Pull open the top drawer using the handle (execute_pull), approach along x-axis (axis=0), distance=0.1
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.1, axis=0)
    except Exception as e:
        print(f"Error in Step 2 (execute_pull drawer_top_handle): {e}")

    try:
        # Step 3: Pick up dice1 (execute_pick_object), approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 3 (execute_pick_object dice1): {e}")

    try:
        # Step 4: Return to ready pose (execute_go_ready)
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in Step 4 (execute_go_ready): {e}")

    try:
        # Step 5: Place dice1 into the top drawer (execute_place_object), approach along z-axis (axis=2)
        # Use the left place pose for the top drawer
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 5 (execute_place_object dice1 into drawer_top): {e}")

    try:
        # Step 6: Return to ready pose (execute_go_ready)
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error in Step 6 (execute_go_ready): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()