from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Pick the handle of the bottom drawer (handle_bottom), approach along x-axis (axis=0)
        robot.primitive_skill.execute_pick("handle_bottom", axis=0)

        # Step 2: Pull the bottom drawer (drawer_bottom) using handle_bottom, approach along x-axis (axis=0)
        robot.primitive_skill.execute_pull("drawer_bottom", "handle_bottom", axis=0, distance=0.1)

        # Step 3: Pick up dice1, approach along z-axis (axis=2)
        robot.primitive_skill.execute_pick("dice1", axis=2)

        # Step 4: Place dice1 into the bottom drawer (drawer_bottom), approach along z-axis (axis=2)
        robot.primitive_skill.execute_place("dice1", "drawer_bottom", axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()