from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for the task: “Put a single dice into the drawer.”

    The sequence strictly follows the specification:
        1) execute_go          : ready-pose  -> drawer-area
        2) execute_pick        : handle_bottom
        3) execute_pull        : drawer_bottom via handle_bottom
        4) execute_pick        : dice1
        5) execute_place       : dice1 into drawer_bottom
        6) execute_push        : drawer_bottom closed
        7) execute_go          : drawer-area  -> ready-pose
    Only predefined skills from RobotController are used.
    """

    robot = RobotController()

    try:
        # ------------------------------------------------------------------
        # 1. Go from the ready-pose to the drawer-area
        # ------------------------------------------------------------------
        robot.execute_movement(mode=7)                                    # execute_go

        # ------------------------------------------------------------------
        # 2. Pick the bottom drawer handle (approach along the x-axis)
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_handle"],
            mode=1,                                                       # execute_pick
            axis=0                                                        # approach along x
        )

        # ------------------------------------------------------------------
        # 3. Pull the bottom drawer open using the handle
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_handle"],
            mode=4,                                                       # execute_pull
            axis=0,
            distance=0.10
        )

        # ------------------------------------------------------------------
        # 4. Pick up dice1 from the floor (approach along the z-axis)
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["dice1"],
            mode=1,                                                       # execute_pick
            axis=2                                                        # approach along z
        )

        # ------------------------------------------------------------------
        # 5. Place dice1 inside the opened bottom drawer
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_place_left"],
            mode=2,                                                       # execute_place
            axis=2
        )

        # ------------------------------------------------------------------
        # 6. Push the bottom drawer closed
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_handle"],
            mode=3,                                                       # execute_push
            axis=0,
            distance=0.10
        )

        # ------------------------------------------------------------------
        # 7. Return to the ready-pose
        # ------------------------------------------------------------------
        robot.execute_movement(mode=7)                                    # execute_go

    except Exception as exc:
        print(f"[Task Error] {exc}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()