from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for:  Insert one die into a drawer.

    Mapping of required skills in specification to RobotController.execute_movement modes
        execute_go          -> mode 7
        execute_pick        -> mode 1
        execute_pull        -> mode 4
        go_to_ready_pose    -> mode 8
        execute_place       -> mode 2
    The axis argument follows the guideline:
        • handle operations (pick / pull)  : axis = 0  (x-axis approach)
        • object operations (pick / place) : axis = 2  (z-axis approach)
    """

    robot = RobotController()

    # ---- Resolve object keys that exist in Object list ----
    handle_key = "drawer_bottom_handle" if "drawer_bottom_handle" in Object else "handle_bottom"
    dice_key   = "dice1"
    drawer_place_key = "drawer_bottom_place_left"

    try:
        # -------------------------------------------------
        # Step-1 : execute_go  (ready-pose -> drawer-area)
        # -------------------------------------------------
        robot.execute_movement(Object[handle_key], mode=7, axis=0)

        # -------------------------------------------------
        # Step-2 : execute_pick  (pick bottom handle)
        # -------------------------------------------------
        robot.execute_movement(Object[handle_key], mode=1, axis=0)

        # -------------------------------------------------
        # Step-3 : execute_pull (open bottom drawer)
        # -------------------------------------------------
        robot.execute_movement(Object[handle_key], mode=4, distance=0.10, axis=0)

        # -------------------------------------------------
        # Step-4 : execute_pick (pick a die)
        # -------------------------------------------------
        robot.execute_movement(Object[dice_key], mode=1, axis=2)

        # -------------------------------------------------
        # Step-5 : go_to_ready_pose
        # -------------------------------------------------
        robot.execute_movement(mode=8)

        # -------------------------------------------------
        # Step-6 : execute_place (place die into bottom drawer)
        # -------------------------------------------------
        robot.execute_movement(Object[drawer_place_key], mode=2, axis=2)

        # (Optional) Return to ready pose after placement
        robot.execute_movement(mode=8)

    except KeyError as err:
        # Graceful degradation if an expected key is missing
        print(f"[ERROR] Missing object in Object list: {err}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()