from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence executing the required primitive skills to place one dice
    into the bottom drawer and finally return the robot to the ready-pose.
    The sequence strictly follows the specification steps and uses only the
    predefined skills exposed through RobotController.execute_movement.
    """

    # Initialise the low-level skill interface
    robot = RobotController()

    try:
        # ------------------------------------------------------------
        # Step 1  – execute_go          : ready-pose  ➜  drawer-area
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)

        # ------------------------------------------------------------
        # Step 2  – execute_pick        : handle_bottom (x-axis grasp)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # ------------------------------------------------------------
        # Step 3  – execute_pull        : open bottom drawer
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"],
                               mode=4, distance=0.10)

        # ------------------------------------------------------------
        # Step 4  – execute_go          : drawer-area  ➜  floor
        # ------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=7)

        # ------------------------------------------------------------
        # Step 5  – execute_pick        : dice1 (z-axis grasp)
        # ------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # ------------------------------------------------------------
        # Step 6  – execute_go          : floor  ➜  drawer-area
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)

        # ------------------------------------------------------------
        # Step 7  – execute_place       : dice1 into bottom drawer
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_place_left"],
                               mode=2, axis=2)

        # ------------------------------------------------------------
        # Step 8  – execute_push        : close bottom drawer
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"],
                               mode=3, distance=0.10)

        # ------------------------------------------------------------
        # Step 9  – execute_go          : drawer-area  ➜  ready-pose
        #           (followed by explicit ready-pose command)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
        robot.execute_movement(mode=8)          # ensure ready-pose

    # Graceful error handling
    except KeyError as err:
        print(f"[TASK-ERROR] Unknown object key: {err}")
    except Exception as err:
        print(f"[TASK-ERROR] Unexpected exception: {err}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()