from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle-level sequence for: “Put a single dice into the drawer.”
    The sequence strictly follows the required specification and
    calls only the predefined skills exposed by RobotController.
    """

    robot = RobotController()

    try:
        # ------------------------------------------------------------
        # 1) execute_go  : ready-pose  ->  drawer-area
        # ------------------------------------------------------------
        # If the exact ‘drawer_area’ waypoint exists, use it;
        # otherwise fall back to a nearby landmark (drawer handle).
        target_drawer_area_pose = Object.get(
            "drawer_area", Object.get("drawer_bottom_handle")
        )
        robot.execute_movement(target_drawer_area_pose, mode=7)

        # ------------------------------------------------------------
        # 2) execute_pick : grasp bottom drawer handle
        #    (approach along x-axis → axis = 0)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # ------------------------------------------------------------
        # 3) execute_pull : open bottom drawer
        # ------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_handle"], mode=4, distance=0.10
        )

        # ------------------------------------------------------------
        # 4) execute_go : drawer-area  ->  floor (towards dice)
        # ------------------------------------------------------------
        target_floor_pose = Object.get("floor", Object.get("dice1"))
        robot.execute_movement(target_floor_pose, mode=7)

        # ------------------------------------------------------------
        # 5) execute_pick : pick up dice1 (approach from above → axis = 2)
        # ------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # ------------------------------------------------------------
        # 6) go_to_ready_pose : return to neutral configuration
        # ------------------------------------------------------------
        robot.execute_movement(mode=8)

        # ------------------------------------------------------------
        # 7) execute_place : place dice inside opened bottom drawer
        # ------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_place_left"], mode=2, axis=2
        )

        # ------------------------------------------------------------
        # 8) go_to_ready_pose : finish task
        # ------------------------------------------------------------
        robot.execute_movement(mode=8)

    # ----------- Basic exception handling ---------------------------------
    except KeyError as missing:
        print(f"[Task Error] Missing object in Object list: {missing}")
    except Exception as err:
        print(f"[Task Error] Unexpected exception: {err}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()