from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle sequence for:
        “Insert one die into a drawer.”

    The sequence strictly follows the Specification steps and uses only the
    predefined movement modes from RobotController.execute_movement():

        mode 1 – execute_pick
        mode 2 – execute_place
        mode 3 – execute_push
        mode 4 – execute_pull
        mode 7 – execute_go
        mode 8 – go_to_ready_pose
    """
    robot = RobotController()

    try:
        # ------------------------------------------------------------------
        # Step 1  – execute_go   ready-pose ➜ drawer-area
        #           (approach the drawer bottom handle so later skills share
        #            the same reference frame “drawer-area”)
        # ------------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)

        # ------------------------------------------------------------------
        # Step 2  – execute_pick handle_bottom at drawer-area
        #           (approach along the x-axis → axis = 0)
        # ------------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # ------------------------------------------------------------------
        # Step 3  – execute_pull drawer_bottom with handle_bottom
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.10
        )

        # ------------------------------------------------------------------
        # Step 4  – execute_go   drawer-area ➜ floor (dice1 location)
        # ------------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=7)

        # ------------------------------------------------------------------
        # Step 5  – execute_pick dice1 on the floor (approach from above)
        # ------------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # ------------------------------------------------------------------
        # Step 6  – go_to_ready_pose from floor
        # ------------------------------------------------------------------
        robot.execute_movement(mode=8)

        # ------------------------------------------------------------------
        # Step 7  – execute_go   ready-pose ➜ drawer-area
        #           (use a placement waypoint inside the opened drawer)
        # ------------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)

        # ------------------------------------------------------------------
        # Step 8  – execute_place dice1 into drawer_bottom
        # ------------------------------------------------------------------
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

        # ------------------------------------------------------------------
        # Step 9  – go_to_ready_pose from drawer-area
        # ------------------------------------------------------------------
        robot.execute_movement(mode=8)

        # ------------------------------------------------------------------
        # Step 10 – execute_push drawer_bottom (close the drawer)
        # ------------------------------------------------------------------
        robot.execute_movement(
            Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.10
        )

    except KeyError as e:
        print(f"[ERROR] Missing object in Object list: {e}")
    except Exception as e:
        print(f"[ERROR] Unexpected exception during task execution: {e}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()
