from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for:  “Place one dice into a drawer.”

    The sequence follows the specification steps by invoking the predefined
    primitive skills through RobotController.execute_movement (modes):
        0 – pick & place combo   4 – pull
        1 – pick                5 – sweep
        2 – place               6 – rotate
        3 – push                7 – go (general move)
        8 – go-to-ready pose    9/10 – gripper open / close
    Only the objects listed in Object_list are referenced.
    """

    robot = RobotController()

    # ------------------------------------------------------------------
    # STEP 1  – execute_go   : ready-pose ➜ drawer-area (bottom handle)
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
    except Exception as exc:
        print(f"[Step-1  execute_go] {exc}")

    # ------------------------------------------------------------------
    # STEP 2  – execute_pick : grasp the bottom drawer handle
    #           (approach along x-axis → axis = 0)
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as exc:
        print(f"[Step-2  execute_pick handle] {exc}")

    # ------------------------------------------------------------------
    # STEP 3  – execute_pull : pull the bottom drawer open
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=4, distance=0.10)
    except Exception as exc:
        print(f"[Step-3  execute_pull] {exc}")

    # ------------------------------------------------------------------
    # STEP 4  – execute_go   : drawer-area ➜ floor (near dice1)
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["dice1"], mode=7)
    except Exception as exc:
        print(f"[Step-4  execute_go] {exc}")

    # ------------------------------------------------------------------
    # STEP 5  – execute_pick : pick up dice1 from the floor
    #           (approach vertically → axis = 2)
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as exc:
        print(f"[Step-5  execute_pick dice1] {exc}")

    # ------------------------------------------------------------------
    # STEP 6  – execute_go   : floor ➜ drawer-area (placement pose)
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=7)
    except Exception as exc:
        print(f"[Step-6  execute_go] {exc}")

    # ------------------------------------------------------------------
    # STEP 7  – execute_place: place dice1 inside the open bottom drawer
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)
    except Exception as exc:
        print(f"[Step-7  execute_place dice1] {exc}")

    # ------------------------------------------------------------------
    # STEP 8  – execute_go_ready : clear need-ready flag
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(mode=8)
    except Exception as exc:
        print(f"[Step-8  execute_go_ready] {exc}")

    # ------------------------------------------------------------------
    # STEP 9  – execute_go   : ready-pose ➜ drawer-area (for push)
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=7)
    except Exception as exc:
        print(f"[Step-9  execute_go] {exc}")

    # ------------------------------------------------------------------
    # STEP 10 – execute_push : close the bottom drawer
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(Object["drawer_bottom_handle"], mode=3, distance=0.10)
    except Exception as exc:
        print(f"[Step-10 execute_push] {exc}")

    # ------------------------------------------------------------------
    # STEP 11 – execute_go_ready : return to ready pose
    # ------------------------------------------------------------------
    try:
        robot.execute_movement(mode=8)
    except Exception as exc:
        print(f"[Step-11 execute_go_ready] {exc}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()