# run_skeleton_task.py (Completed Executable Code)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Object and Location Names (from feedback and PDDL) ===
        # Objects
        dice1 = 'dice1'
        dice2 = 'dice2'
        handle_top = 'handle_top'
        drawer_top = 'drawer_top'
        ready_pose = 'ready-pose'
        floor = 'floor'
        drawer_area = 'drawer-area'

        # Handles and drawers
        handle_bottom = 'handle_bottom'
        handle_middle = 'handle_middle'
        drawer_bottom = 'drawer_bottom'
        drawer_middle = 'drawer_middle'

        # For exploration: missing predicate detection
        # We'll attempt to execute a plan and, if it fails, perform exploration to identify missing predicates

        # === PLAN: Put dice1 and dice2 into drawer_top, return to ready-pose ===

        # Helper: Move to a location if not already there
        def ensure_robot_at(location):
            # Get current robot location from environment/task if possible
            # For this skeleton, we assume we always need to move
            try:
                obs, reward, done = execute_go(env, task, from_location='ready-pose', to_location=location)
            except Exception as e:
                print(f"[Error] execute_go to {location}: {e}")

        # 1. Move to dice1 location (assume on floor)
        try:
            obs, reward, done = execute_go(env, task, from_location='ready-pose', to_location=floor)
        except Exception as e:
            print(f"[Error] execute_go to floor: {e}")

        # 2. Pick up dice1
        try:
            obs, reward, done = execute_pick(env, task, object_name=dice1, location=floor)
        except Exception as e:
            print(f"[Error] execute_pick dice1: {e}")
            # Exploration: Try to identify missing predicate
            print("[Exploration] Attempting to identify missing predicate for dice1 pick...")
            # Try to use exploration skills if available (simulate exploration)
            # For example, try to identify the object
            try:
                obs, reward, done = execute_go_identify(env, task, robot='robot', from_location=floor, to_location=floor)
                print("[Exploration] Ran execute_go_identify for dice1.")
            except Exception as ex:
                print(f"[Exploration Error] execute_go_identify: {ex}")

        # 3. Return to ready-pose (if need-ready is set)
        try:
            obs, reward, done = execute_go_ready(env, task, from_location=floor)
        except Exception as e:
            print(f"[Error] execute_go_ready from floor: {e}")

        # 4. Move to drawer_top
        try:
            obs, reward, done = execute_go(env, task, from_location='ready-pose', to_location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_go to drawer_area: {e}")

        # 5. Pick up handle_top (to open drawer_top)
        try:
            obs, reward, done = execute_pick(env, task, object_name=handle_top, location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_pick handle_top: {e}")

        # 6. Pull to open drawer_top
        try:
            obs, reward, done = execute_pull(env, task, drawer=drawer_top, handle=handle_top, location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_pull drawer_top: {e}")

        # 7. Place dice1 into drawer_top
        try:
            obs, reward, done = execute_place(env, task, object_name=dice1, drawer=drawer_top, location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_place dice1 in drawer_top: {e}")

        # 8. Return to ready-pose (if need-ready is set)
        try:
            obs, reward, done = execute_go_ready(env, task, from_location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_go_ready from drawer_area: {e}")

        # 9. Move to dice2 location (assume on floor)
        try:
            obs, reward, done = execute_go(env, task, from_location='ready-pose', to_location=floor)
        except Exception as e:
            print(f"[Error] execute_go to floor for dice2: {e}")

        # 10. Pick up dice2
        try:
            obs, reward, done = execute_pick(env, task, object_name=dice2, location=floor)
        except Exception as e:
            print(f"[Error] execute_pick dice2: {e}")
            # Exploration: Try to identify missing predicate
            print("[Exploration] Attempting to identify missing predicate for dice2 pick...")
            try:
                obs, reward, done = execute_go_identify(env, task, robot='robot', from_location=floor, to_location=floor)
                print("[Exploration] Ran execute_go_identify for dice2.")
            except Exception as ex:
                print(f"[Exploration Error] execute_go_identify: {ex}")

        # 11. Return to ready-pose (if need-ready is set)
        try:
            obs, reward, done = execute_go_ready(env, task, from_location=floor)
        except Exception as e:
            print(f"[Error] execute_go_ready from floor (dice2): {e}")

        # 12. Move to drawer_top
        try:
            obs, reward, done = execute_go(env, task, from_location='ready-pose', to_location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_go to drawer_area (dice2): {e}")

        # 13. Place dice2 into drawer_top
        try:
            obs, reward, done = execute_place(env, task, object_name=dice2, drawer=drawer_top, location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_place dice2 in drawer_top: {e}")

        # 14. Return to ready-pose (if need-ready is set)
        try:
            obs, reward, done = execute_go_ready(env, task, from_location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_go_ready from drawer_area (after dice2): {e}")

        # 15. Push drawer_top to close it
        try:
            obs, reward, done = execute_push(env, task, drawer=drawer_top, location=drawer_area)
        except Exception as e:
            print(f"[Error] execute_push drawer_top: {e}")

        # 16. Return to ready-pose
        try:
            obs, reward, done = execute_go(env, task, from_location=drawer_area, to_location='ready-pose')
        except Exception as e:
            print(f"[Error] execute_go to ready-pose (final): {e}")

        print("[Task] Finished putting dice1 and dice2 into drawer_top and returned to ready-pose.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
