# run_skeleton_task.py (Completed Executable)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use skills directly as provided

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")

    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration to Identify Missing Predicate ===
        # The feedback indicates the predicate (need-ready) is critical.
        # In some domains, after executing an action, need-ready is set and must be cleared
        # by performing the execute_go_ready skill before taking further actions.

        # For demonstration, we perform an exploration sequence involving all key skills.
        # This traces when (need-ready) becomes True and ensures execute_go_ready is called before further actions.

        # Replace with your actual object/drawer/location keys as needed
        # (Assuming demo names to illustrate exploration and need-ready management logic)
        objects = list(positions.keys())
        if len(objects) < 2:
            print("Not enough objects found in scene for demo exploration! Need at least 2.")
            return

        # Hypothetical mapping for demo; replace with actual types
        obj = objects[0]   # assume a pickable object (not handle)
        loc = positions[obj]  # position for that object (if needed by skill)
        drawer = None
        handle = None
        for k in objects:
            if "drawer" in k:
                drawer = k
            if "handle" in k:
                handle = k
        locationA = list(positions.values())[0]
        locationB = list(positions.values())[1]
        # NOTE: 
        # In a real scenario, these names/roles should be replaced by the true pddl-typed names.

        # For need-ready exploration, we run through key action pairs
        # and trigger execute_go_ready after any skill that sets (need-ready).

        # Step 1: Try execute_pick (should set need-ready)
        print("[Exploration] Executing execute_pick on:", obj)
        try:
            obs, reward, done = execute_pick(
                env,
                task,
                obj,
                locationA
            )
            print("[Exploration] 'execute_pick' executed. Now execute 'execute_go_ready'.")
        except Exception as e:
            print("Exception during execute_pick:", e)
            return

        # Step 2: Execute go_ready to clear need-ready
        try:
            obs, reward, done = execute_go_ready(
                env,
                task,
                locationA
            )
            print("[Exploration] 'execute_go_ready' executed to clear 'need-ready'.")
        except Exception as e:
            print("Exception during execute_go_ready:", e)
            return

        # Step 3: Try execute_place if we have a drawer
        if drawer:
            print("[Exploration] Executing execute_place with:", obj, "in", drawer)
            try:
                obs, reward, done = execute_place(
                    env,
                    task,
                    obj,
                    drawer,
                    locationA
                )
                print("[Exploration] 'execute_place' executed. Now execute 'execute_go_ready'.")
            except Exception as e:
                print("Exception during execute_place:", e)
                return

            # Step 4: Clear 'need-ready' after place
            try:
                obs, reward, done = execute_go_ready(
                    env,
                    task,
                    locationA
                )
                print("[Exploration] 'execute_go_ready' executed to clear 'need-ready'.")
            except Exception as e:
                print("Exception during execute_go_ready (post-place):", e)
                return
        else:
            print("No drawer found for 'execute_place' demonstration.")

        # Step 5: Test execute_push and execute_pull if drawer and handle exist
        if drawer and handle:
            print("[Exploration] Executing execute_pick on handle:", handle)
            try:
                obs, reward, done = execute_pick(
                    env,
                    task,
                    handle,
                    locationA
                )
            except Exception as e:
                print("Exception during execute_pick (handle):", e)
                return

            print("[Exploration] Executing execute_pull for drawer:", drawer, "handle:", handle)
            try:
                obs, reward, done = execute_pull(
                    env,
                    task,
                    drawer,
                    handle,
                    locationA
                )
                print("[Exploration] 'execute_pull' executed.")
            except Exception as e:
                print("Exception during execute_pull:", e)
                return

            print("[Exploration] Executing execute_push for drawer:", drawer)
            try:
                obs, reward, done = execute_push(
                    env,
                    task,
                    drawer,
                    locationA
                )
                print("[Exploration] 'execute_push' executed.")
            except Exception as e:
                print("Exception during execute_push:", e)
        else:
            print("No drawer and/or handle found for 'execute_pull/push' demonstration.")

        # Step 6: Test additional skills (sweep, go, gripper, etc.) as desired
        print("[Exploration] Executing execute_sweep on:", obj)
        try:
            obs, reward, done = execute_sweep(
                env,
                task,
                obj,
                locationA
            )
            print("[Exploration] 'execute_sweep' executed.")
        except Exception as e:
            print("Exception during execute_sweep:", e)

        print("[Exploration] Executing execute_go from locationA to locationB.")
        try:
            obs, reward, done = execute_go(
                env,
                task,
                locationA,
                locationB
            )
            print("[Exploration] 'execute_go' executed.")
        except Exception as e:
            print("Exception during execute_go:", e)

        print("[Exploration] Executing execute_gripper.")
        try:
            obs, reward, done = execute_gripper(
                env,
                task
            )
            print("[Exploration] 'execute_gripper' executed.")
        except Exception as e:
            print("Exception during execute_gripper:", e)

        print("[Exploration] Finished. Key predicate (need-ready) and required 'execute_go_ready' interleaving demonstrated.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()
