"""Module to insert one die into a drawer using robot primitive skills."""
from Object_list import Object
from skill_mapping import RobotController

def insert_die_into_drawer():
    """Insert one die into a drawer following valid action preconditions and sequence."""
    robot = RobotController()

    # Move from ready-pose to floor
    try:
        robot.execute_movement(Object.get("ready-pose", None), Object.get("floor", None), mode=7)
    except Exception as exc:
        robot.execute_movement(mode=7)

    # Pick up handle_bottom from floor (axis=0 for handle)
    try:
        robot.execute_movement(Object.get("handle_bottom", None), mode=1, axis=0)
    except Exception as exc:
        robot.execute_movement(mode=1, axis=0)

    # Move to drawer-area with handle
    try:
        robot.execute_movement(Object.get("floor", None), Object.get("drawer-area", None), mode=7)
    except Exception as exc:
        robot.execute_movement(mode=7)

    # Pull drawer_bottom using handle_bottom at drawer-area
    try:
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=4, distance=0.1)
    except Exception as exc:
        robot.execute_movement(mode=4, distance=0.1)

    # Move to floor to pick up dice1
    try:
        robot.execute_movement(Object.get("drawer-area", None), Object.get("floor", None), mode=7)
    except Exception as exc:
        robot.execute_movement(mode=7)

    # Pick up dice1 from floor (axis=2 for general object)
    try:
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    except Exception as exc:
        robot.execute_movement(mode=1, axis=2)

    # Move to drawer-area with dice1
    try:
        robot.execute_movement(Object.get("floor", None), Object.get("drawer-area", None), mode=7)
    except Exception as exc:
        robot.execute_movement(mode=7)

    # Place dice1 into drawer_bottom at drawer-area (axis=2)
    try:
        robot.execute_movement(Object.get("drawer_bottom_place_left", None), mode=2, axis=2)
    except Exception as exc:
        robot.execute_movement(mode=2, axis=2)

    # Push drawer_bottom at drawer-area to close
    try:
        robot.execute_movement(Object.get("drawer_bottom_handle", None), mode=3, distance=0.1)
    except Exception as exc:
        robot.execute_movement(mode=3, distance=0.1)

    # Move from drawer-area to ready-pose
    try:
        robot.execute_movement(Object.get("drawer-area", None), Object.get("ready-pose", None), mode=7)
    except Exception as exc:
        robot.execute_movement(mode=7)

def main():
    """Main entry point to insert one die into a drawer."""
    insert_die_into_drawer()

if __name__ == "__main__":
    main()