from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Place one dice (dice1) into a drawer (drawer_bottom) following the explicit state transitions
    and requirements as specified in the PDDL domain.
    """
    robot = RobotController()

    # Step 1: Move from ready-pose to handle_bottom location
    robot.execute_movement(Object["ready_pose"], Object["drawer_bottom_handle"], mode=7)  # execute_go

    # Step 2: Pick handle_bottom (handle pick, no need-ready)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=5, axis=0)  # execute_pick_handle

    # Step 3: Pull drawer_bottom using handle_bottom (drawer must be unlocked and closed)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

    # Step 4: Move from handle_bottom to dice1 location
    robot.execute_movement(Object["drawer_bottom_handle"], Object["dice1"], mode=7)  # execute_go

    # Step 5: Pick dice1 (object pick, sets need-ready)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick_object

    # Step 6: Return to ready-pose to clear need-ready
    robot.execute_movement(Object["dice1"], Object["ready_pose"], mode=8)  # execute_go_ready

    # Step 7: Move from ready-pose to drawer_bottom location
    robot.execute_movement(Object["ready_pose"], Object["drawer_bottom_place"], mode=7)  # execute_go

    # Step 8: Place dice1 into drawer_bottom (drawer must be open, not full, sets need-ready)
    robot.execute_movement(Object["drawer_bottom_place"], mode=2, axis=2)  # execute_place_object

    # Step 9: Return to ready-pose to clear need-ready
    robot.execute_movement(Object["drawer_bottom_place"], Object["ready_pose"], mode=8)  # execute_go_ready

    # Step 10: Move from ready-pose to handle_bottom location
    robot.execute_movement(Object["ready_pose"], Object["drawer_bottom_handle"], mode=7)  # execute_go

    # Step 11: Push drawer_bottom closed (drawer must be open)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=3, axis=0, distance=0.1)  # execute_push

    # Step 12: Move from handle_bottom to ready-pose
    robot.execute_movement(Object["drawer_bottom_handle"], Object["ready_pose"], mode=7)  # execute_go

def main():
    """
    Main entry point for the task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()