"""Module to insert one die into a drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def insert_die_into_drawer():
    """Insert one die into a drawer."""
    robot = RobotController()

    # Select the first available die and drawer
    die = Object.get("dice1", None)
    drawer = Object.get("drawer_bottom", None)
    floor = Object.get("floor", None)

    # Move to the die's location if not already there
    robot.execute_movement(Object.get("ready-pose", None), floor, mode=7)

    # Pick up the die from the floor (approach along z-axis)
    robot.execute_movement(die, mode=1, axis=2)

    # Move to the drawer area if needed (assuming drawer is at floor)
    # (No-op if already at floor)

    # Place the die into the drawer (assumes drawer is open and not full)
    robot.execute_movement(drawer, mode=2, axis=2)

def main():
    """Main function to insert one die into a drawer."""
    insert_die_into_drawer()

if __name__ == "__main__":
    main()