from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Drops one dice into any open drawer.
    """
    robot = RobotController()

    # Select any dice on the floor
    dice = None
    for dice_name in ["dice1", "dice2"]:
        if robot.is_on_floor(Object[dice_name]):
            dice = Object[dice_name]
            break
    if dice is None:
        return

    # Select any open drawer
    open_drawer = None
    for drawer_name in ["drawer_bottom", "drawer_middle", "drawer_top"]:
        if robot.is_drawer_open(drawer_name):
            open_drawer = drawer_name
            break
    if open_drawer is None:
        return

    # Move to the dice and pick it up
    robot.execute_movement(dice, mode=1, axis=2)
    robot.execute_movement(mode=8)  # Go to ready pose after pick

    # Move to the open drawer and drop/place the dice
    place_location = Object[f"{open_drawer}_place_left"]
    robot.execute_movement(place_location, mode=2, axis=2)

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()