"""Module to insert one die into a drawer using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def insert_die_into_drawer():
    """Insert one die into the drawer."""
    robot = RobotController()
    # Move to the die location if not already there
    robot.execute_movement(Object["dice1"], mode=1, axis=2)
    # Place the die into the open drawer (assumes drawer is already open)
    robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

def main():
    """Main function to execute the insert die task."""
    insert_die_into_drawer()

if __name__ == "__main__":
    main()