"""Module to store a dice inside the drawer using robot primitive skills."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store dice1 inside drawer_bottom."""
    robot = RobotController()

    try:
        # Move to floor and pick up dice1
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Move to floor and pick up handle_bottom
        robot.execute_movement(Object["handle_bottom"], mode=1, axis=2)
        # Move to drawer-area and pull open drawer_bottom using handle_bottom
        robot.execute_movement(Object["handle_bottom"], mode=4, axis=0, distance=0.1)
        # Move to floor and pick up dice1 again (if not holding)
        if not robot.is_holding("dice1"):
            robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Move to drawer-area and place dice1 into drawer_bottom
        robot.execute_movement(Object["drawer_bottom"], mode=2, axis=2)
        # Push drawer_bottom to close it
        robot.execute_movement(Object["drawer_bottom"], mode=3, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point to execute the dice storing task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()