"""Module to drop any dice into any open drawer using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Drops any dice into any open drawer."""
    robot = RobotController()

    # Select any dice
    dice_candidates = ["dice1", "dice2"]
    dice_to_use = None
    for dice in dice_candidates:
        if Object.get(dice) is not None:
            dice_to_use = dice
            break
    if dice_to_use is None:
        print("No dice available.")
        return

    # Find any open drawer place location
    open_drawer_places = [
        ("drawer_bottom", "drawer_bottom_place_left"),
        ("drawer_bottom", "drawer_bottom_place_right"),
        ("drawer_middle", "drawer_middle_place_left"),
        ("drawer_middle", "drawer_middle_place_right"),
        ("drawer_top", "drawer_top_place_left"),
        ("drawer_top", "drawer_top_place_right"),
    ]
    drawer_to_use = None
    place_location = None
    for drawer, place in open_drawer_places:
        if Object.get(place) is not None and Object.get(drawer) is not None:
            # Assume the drawer is open if its place location exists
            drawer_to_use = drawer
            place_location = place
            break
    if drawer_to_use is None or place_location is None:
        print("No open drawer available.")
        return

    # Pick up the dice
    robot.execute_movement(Object[dice_to_use], mode=1, axis=2)
    # Place the dice into the open drawer
    robot.execute_movement(Object[place_location], mode=2, axis=2)

def main():
    """Main entry point."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()