from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Store a dice inside the drawer.
    """
    robot = RobotController()

    # Step 1: Pick the handle of the bottom drawer (approach along x-axis)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

    # Step 2: Pull the bottom drawer open using the handle (approach along x-axis, longer distance)
    robot.execute_movement(Object["drawer_bottom_handle"], mode=4, axis=0, distance=0.1)

    # Step 3: Pick up dice1 (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 4: Place dice1 into the bottom drawer (approach along z-axis)
    robot.execute_movement(Object["drawer_bottom_place_left"], mode=2, axis=2)

def main():
    """
    Main function to execute the task.
    """
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()