"""Module to drop one dice into any open drawer."""
from Object_list import Object
from skill_mapping import RobotController

def drop_one_dice_into_any_open_drawer():
    """Drop one dice into any open drawer."""
    robot = RobotController()
    try:
        # Select any dice on the floor
        dice = None
        for dice_name in ["dice1", "dice2"]:
            if Object[dice_name].is_on_floor():
                dice = Object[dice_name]
                break
        if dice is None:
            print("No dice available on the floor.")
            return

        # Find any open drawer that is not full
        open_drawer = None
        for drawer_name in ["drawer_bottom", "drawer_middle", "drawer_top"]:
            drawer = Object[drawer_name]
            if drawer.is_open() and not drawer.is_full():
                open_drawer = drawer
                break
        if open_drawer is None:
            print("No open drawer available.")
            return

        # Pick up the dice (approach along z-axis: axis=2)
        robot.execute_movement(dice, mode=1, axis=2)
        # Place the dice into the open drawer (approach along z-axis: axis=2)
        place_location = Object.get_drawer_place_location(open_drawer.name)
        robot.execute_movement(place_location, mode=2, axis=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the task."""
    drop_one_dice_into_any_open_drawer()

if __name__ == "__main__":
    main()