from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Move to dice location (Assume already at current_location? If needed, use execute_go)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # [Frozen Code Start/End] - pick dice

        # Step 2: Move to handle location (simulate go)
        # Since execute_go is required, we move to handle location.
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go to handle location

        # Step 3: Pick up the drawer handle (approach along x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 4: Pull to open the drawer using the handle
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 5: Move to drawer place location (simulate go)
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)  # execute_go to place-in-drawer location

        # Step 6: Place the dice into the drawer
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 7: Push to close the drawer
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()
