from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle plan for: Insert one die into a drawer.
    Step-by-step:
      1. Pick up dice1 from the floor (z-axis approach).
      2. Pick up the top drawer handle (x-axis approach).
      3. Pull the drawer open using the handle (x-axis, distance=0.1).
      4. Place the die into the drawer (z-axis approach).
      5. Push the drawer handle to close it (x-axis, distance=0.15).
      6. Return robot to ready pose at the end.
    """
    robot = RobotController()

    try:
        # Step 1: execute_pick_object (pick the die, z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: execute_pick_handle (pick handle, x-axis)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Step 3: execute_pull (pull drawer using handle, x-axis, distance=0.1)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Step 4: execute_place_object (place die into drawer, z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 5: execute_push (push drawer handle to close, x-axis, distance=0.15)
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.15)

        # Step 6: Optionally return to ready pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
